string GetDescription()
{
	return "Creates a random melody line with repetitve rythm and cenetered aroun the tonic of the chord. \nLast bar gets an ending (single note)";
}

int first_pitch = 0;
int last_pitch = 0;

void SetFirstPitch(int f)
{
	first_pitch = f;
	last_pitch = f;	
}	

int GetNextPitch(int p)
{
	int cur_pitch = p;
	if (cur_pitch - 7 > last_pitch) cur_pitch -= 12;
	last_pitch = cur_pitch;
	return cur_pitch;
}

void Render(RenderPart @p)
{
	SetFirstPitch(p.GetHarmonicEventPitch(0,0));
	
	double speed = 0.5;
	if (p.GetTempo() < 90) speed /= 2.0;
	if (p.GetTempo() > 180) speed *= 2.0;
	
	double len = RndFloat(0.5, 1.0);
	
	Time t = CreateTime(p.GetStartBar(), 0);
	
	int co = 4;
	if (RndInt(0,1) == 0) co = 8;
	int cnt = 0;
	
	while (t.m_Bar < p.GetEndBar())
	{
		int harm = p.GetHarmonic(t);
		
		cnt++;
		
			if (RndInt(0,2) != 0)
			{
				if (cnt % co == 0)
				{
					p.AddNote(t, CreateTime(t.m_Bar, t.m_Pos + speed * len), GetNextPitch(p.GetHarmonicEventPitch(harm,RndInt(-1,1))) , RndInt(120,126));	
				}
				else p.AddNote(t, CreateTime(t.m_Bar, t.m_Pos + speed * len), GetNextPitch(p.GetHarmonicEventPitch(harm,0)) , RndInt(120,126));	
			}
			else
			{
				if (cnt % co == 0)
				{
					int up = RndInt(-1,1);
					p.AddNote(t, CreateTime(t.m_Bar, t.m_Pos + speed * len / 2), GetNextPitch(p.GetHarmonicEventPitch(harm,up)) , RndInt(120,126));	
					p.AddNote(CreateTime(t.m_Bar, t.m_Pos + speed / 2), CreateTime(t.m_Bar, t.m_Pos + speed / 2 + (( speed / 2) * len)), GetNextPitch(p.GetHarmonicEventPitch(harm,up)) , RndInt(120,126));		
				}
				else 
				{
					p.AddNote(t, CreateTime(t.m_Bar, t.m_Pos + speed * len / 2), GetNextPitch(p.GetHarmonicEventPitch(harm,0)) , RndInt(120,126));	
					p.AddNote(CreateTime(t.m_Bar, t.m_Pos + speed / 2), CreateTime(t.m_Bar, t.m_Pos + speed / 2 + (( speed / 2) * len)), GetNextPitch(p.GetHarmonicEventPitch(harm,0)) , RndInt(120,126));	
					
				}
			}
		
		t.m_Pos += speed;
		if (t.m_Pos >= p.GetUniquePart().GetMetrum()-0.1)
		{
			t.m_Pos = 0;
			t.m_Bar++;	
		}	
	}
}